/* ***************************************************************************+
 * ITX package (cnrg.itx) for telephony application programming.              *
 * Copyright (c) 1999  Cornell University, Ithaca NY.                         *
 * A copy of the license is distributed with this package.  Look in the docs  *
 * directory, filename GPL.  Contact information: bergmark@cs.cornell.edu     *
 ******************************************************************************/


package cnrg.itx.datax;

import java.util.*;
import java.net.*;
import java.io.*;
import cnrg.itx.datax.devices.*;

/**
 * Channel that doesn't ever copy data. Supports everything else, just has no readerThread.
 */
public class DummyChannel extends Channel
{
	/**
	 * pretends to open the channel. Creates buffer, but does not start a thread.
	 */
	public void open() throws DataException
	{
		if (closed)
		{
			throw new DataException("Channel closed");
		}
		
		// Create the input pipe
		try
		{
			pipedOutput = new PipedOutputStream();
			pipedInput = new PipedInputStream();
			pipedOutput.connect(pipedInput);		
		}
		catch (IOException e)
		{
			throw new DataException(e.getMessage());
		}
		
		// DON'T Create and start the reader thread
		running = true;

		
		// Start the source
		source.start();
	}
	
	/**
	 * Channel reader thread function. Does nothing
	 */
	public void run()
	{
	}
	
	/**
	 * Method to close the Channel. Code to stop thread is removed.
	 */
	public void close() 
	{
		// Return if the channel is closed
		if (closed)
		{
			return;
		}
		
		// Clear all the resources. Close the source and all the destinations
		source.close();

		// Stop the reader thread
		if (running)
		{
			running = false;
			try
			{
				pipedInput.close();
				pipedOutput.close();
			}
			catch (IOException e)
			{
			}
		
		}
		
		// Close all destinations
		for(Enumeration e = destinations.elements() ; e.hasMoreElements();)
		{
			((Destination)e.nextElement()).close();
		}
		
		closed = true;
	}
}